//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D txDiffuse : register( t0 );
SamplerState samLinear : register( s0 );

cbuffer cbNeverChanges : register( b0 )
{
    float FOV;
    float ScreenRatio;
};


cbuffer cbChangesEveryFrame : register( b1 )
{
    float SequenceRatio;
    float SequenceDuration;
};


//--------------------------------------------------------------------------------------
struct PS_INPUT
{
    float4 Pos : SV_POSITION;
    float2 Tex : TEXCOORD0;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( float4 Pos : POSITION,  float2 Tex : TEXCOORD0 )
{
	PS_INPUT output = (PS_INPUT)0;
	output.Pos = Pos;
    output.Tex = Tex;
    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS( PS_INPUT input) : SV_Target
{

  /*  float2 position = 2.0 * (input.Tex.xy  - float2( 0.5, 0.5 ) );
    position.x *= ScreenRatio;

    // Discard fragments outside the circle.
	float dis = length( position );
    const float radius = 0.7f;
	if( dis > radius ) {
		discard;
	}
	
	// Evaluate z.
	float z = sqrt( radius * radius - position.x * position.x - position.y * position.y );
	
	// Evaluate normal.
	float3 normal = normalize( float3( position.x, position.y, z ) );
	
    float ang = SequenceRatio * 2* 3.1415;
    float cosAng = cos(ang);
    float sinAng = sin(ang);
	// Apply simple lighting.
	float2 centeredMouse = 2 * float2(cosAng,sinAng); //float2(0.5, 0.5 );
	float3 view = normalize( float3( centeredMouse, 1 ) );
	float proj = dot( view, normal );
	
	// Out!
	return float4( proj,proj, proj, 1.0 );*/


 
    float ang = SequenceRatio * 3.1415;
    float cosAng = cos(ang);
    float sinAng = sin(ang);
    float2 coords = float2( cosAng * input.Tex.x + sinAng * input.Tex.y,
                            -sinAng * input.Tex.x + cosAng * input.Tex.y ) * abs(sinAng) * 5;
        
    float4 colorTex = txDiffuse.Sample( samLinear, coords );
    float4 colorFlash = float4(1,1,1,1);
    float factor = (2.0 * (SequenceRatio - 0.5)) * (2.0 * (SequenceRatio - 0.5)) * (2.0 * (SequenceRatio - 0.5)) * (2.0 * (SequenceRatio - 0.5));
    return colorTex * (1.0 - factor) +  colorFlash * factor;
}


